/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.container;

import com.becon.opencelium.backend.container.Command;
import com.becon.opencelium.backend.database.mysql.service.ConnectionHistoryService;
import com.becon.opencelium.backend.enums.Action;
import com.becon.opencelium.backend.resource.connection.ConnectionDTO;
import com.becon.opencelium.backend.utility.patch.PatchHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.diff.JsonDiff;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ConnectionUpdateTracker {
    private static final Integer QUEUE_CAPACITY = 40;
    private static final long SAVING_DURATION = 900000L;
    private final Map<Long, LinkedBlockingDeque<Command>> queues;
    private static final Logger logger = LoggerFactory.getLogger(ConnectionUpdateTracker.class);
    private final ObjectMapper objectMapper;
    private final ConnectionHistoryService CHS;
    private final PatchHelper patchHelper;

    public ConnectionUpdateTracker(@Qualifier(value="connectionHistoryServiceImp") ConnectionHistoryService CHS, ObjectMapper objectMapper, PatchHelper patchHelper) {
        this.CHS = CHS;
        this.queues = new ConcurrentHashMap();
        this.objectMapper = objectMapper;
        this.patchHelper = patchHelper;
    }

    public Command undo(Long connectionId) {
        LinkedBlockingDeque commands;
        if (this.queues.containsKey(connectionId) && !(commands = (LinkedBlockingDeque)this.queues.get(connectionId)).isEmpty()) {
            return (Command)commands.removeLast();
        }
        return null;
    }

    public void push(Command command) {
        if (this.queues.containsKey(command.getConnectionId())) {
            try {
                ((LinkedBlockingDeque)this.queues.get(command.getConnectionId())).add(command);
            }
            catch (IllegalStateException e) {
                ((LinkedBlockingDeque)this.queues.get(command.getConnectionId())).remove();
                ((LinkedBlockingDeque)this.queues.get(command.getConnectionId())).add(command);
            }
        } else {
            LinkedBlockingDeque<Command> newDeque = new LinkedBlockingDeque<Command>(QUEUE_CAPACITY);
            newDeque.add(command);
            this.queues.put(command.getConnectionId(), newDeque);
        }
    }

    public void pushAndMakeHistory(ConnectionDTO before, ConnectionDTO after, JsonPatch patch) {
        JsonPatch forUndo;
        if (after.getFieldBinding() == null && before.getFieldBinding().isEmpty()) {
            before.setFieldBinding(null);
        }
        if (after.getFromConnector() != null && after.getFromConnector().getMethods() == null && before.getFromConnector() != null && before.getFromConnector().getMethods().isEmpty()) {
            before.getFromConnector().setMethods(null);
        }
        if (after.getToConnector() != null && after.getToConnector().getMethods() == null && before.getToConnector() != null && before.getToConnector().getMethods().isEmpty()) {
            before.getToConnector().setMethods(null);
        }
        if (after.getFromConnector() != null && after.getFromConnector().getOperators() == null && before.getFromConnector() != null && before.getFromConnector().getOperators().isEmpty()) {
            before.getFromConnector().setOperators(null);
        }
        if (after.getToConnector() != null && after.getToConnector().getOperators() == null && before.getToConnector() != null && before.getToConnector().getOperators().isEmpty()) {
            before.getToConnector().setOperators(null);
        }
        if (this.patchHelper.isEmpty(forUndo = JsonDiff.asJsonPatch((JsonNode)this.objectMapper.valueToTree((Object)after), (JsonNode)this.objectMapper.valueToTree((Object)before)))) {
            return;
        }
        this.push(new Command(before.getConnectionId(), forUndo));
        this.CHS.makeHistoryAndSave(before.getConnectionId(), patch, Action.MODIFY);
    }

    @Scheduled(initialDelay=0L, fixedDelay=60000L)
    private void clear() {
        for (Map.Entry entry : this.queues.entrySet()) {
            Command command;
            long currentTimeMillis = System.currentTimeMillis();
            LinkedBlockingDeque queue = (LinkedBlockingDeque)entry.getValue();
            Iterator iterator = queue.iterator();
            while (iterator.hasNext() && (command = (Command)iterator.next()).getTimestamp() + 900000L < currentTimeMillis) {
                iterator.remove();
                logger.info("Connection(id = {}) history removed because time limit exceeded. This connection has {} chance(s) to undo", (Object)command.getConnectionId(), (Object)queue.size());
                if (!queue.isEmpty()) continue;
                this.queues.remove(entry.getKey());
            }
        }
    }
}

