/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.configuration.interceptors;

import com.becon.opencelium.backend.commons.ThreadLocalSingleton;
import com.becon.opencelium.backend.constant.props.ConnectorProps;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class MasterPasswordInterceptor
implements HandlerInterceptor {
    private final ConnectorProps connectorProps;

    public MasterPasswordInterceptor(ConnectorProps connectorProps) {
        this.connectorProps = connectorProps;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String masterPassword = Objects.requireNonNullElse(request.getHeader("X-Master-Password"), "");
        ThreadLocalSingleton.setHasMasterPassword((StringUtils.isNotBlank((CharSequence)this.connectorProps.getMasterPassword()) && this.connectorProps.getMasterPassword().equals(masterPassword) ? 1 : 0) != 0);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ThreadLocalSingleton.remove();
    }
}

