/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.configuration;

import com.becon.opencelium.backend.configuration.LdapProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.security.ldap")
public class LdapProperties {
    public static final String CONNECT_TIMEOUT_KEY = "com.sun.jndi.ldap.connect.timeout";
    public static final String READ_TIMEOUT_KEY = "com.sun.jndi.ldap.read.timeout";
    private String urls;
    private String username;
    private String password;
    private String timeout = "30000";
    private String userSearchBase = "";
    private String userSearchFilter = "";
    private String groupSearchBase = "";
    private String groupSearchFilter = "";
    private List<Group2Role> groupRoleMapping = new ArrayList();
    private String defaultRole;
    @Value(value="${logging.level.org.springframework.security.ldap:OFF}")
    private String showLogs;

    public String getRoleByGroup(String groupDN) {
        return this.groupRoleMapping.stream().filter(mapping -> Objects.equals(groupDN, mapping.ldapGroup)).map(Group2Role::getOcRole).findFirst().orElseThrow();
    }

    public List<String> getGroups() {
        return this.groupRoleMapping.stream().map(Group2Role::getLdapGroup).toList();
    }

    public String getUrls() {
        return this.urls;
    }

    public void setUrls(String urls) {
        this.urls = urls;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    public void setGroupSearchBase(String groupSearchBase) {
        this.groupSearchBase = groupSearchBase;
    }

    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
    }

    public List<Group2Role> getGroupRoleMapping() {
        return this.groupRoleMapping;
    }

    public void setGroupRoleMapping(List<Group2Role> groupRoleMapping) {
        this.groupRoleMapping = groupRoleMapping;
    }

    public String getDefaultRole() {
        return this.defaultRole;
    }

    public void setDefaultRole(String defaultRole) {
        this.defaultRole = defaultRole;
    }

    public String isShowLogs() {
        return this.showLogs;
    }

    public void setShowLogs(String showLogs) {
        this.showLogs = showLogs;
    }
}

