/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.authentication;

import com.becon.opencelium.backend.authentication.ApiAuth;
import com.becon.opencelium.backend.database.mysql.entity.Connector;
import com.becon.opencelium.backend.database.mysql.entity.RequestData;
import com.becon.opencelium.backend.invoker.entity.Invoker;
import com.becon.opencelium.backend.invoker.entity.RequiredData;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class TokenAuth
implements ApiAuth {
    private final Invoker invoker;
    private RestTemplate restTemplate;

    public TokenAuth(Invoker invoker) {
        this.invoker = invoker;
        this.restTemplate = new RestTemplate();
    }

    public List<RequestData> getAccessCredentials(Connector connector) {
        return connector.getRequestData();
    }

    public List<RequestData> getAccessCredentials(Connector connector, ResponseEntity<?> responseEntity) {
        RequiredData requiredData = this.invoker.getRequiredData().stream().filter(i -> i.getName().equals("token")).findFirst().orElseThrow(() -> new RuntimeException("field not found"));
        if (!requiredData.getValue().contains("%")) {
            return connector.getRequestData();
        }
        List requestDataList = connector.getRequestData();
        RequestData requestData = new RequestData(requiredData);
        String token = this.getValueFromResponse(responseEntity, requiredData);
        requestData.setValue(token);
        requestDataList.add(requestData);
        return requestDataList;
    }

    private String getValueFromResponse(ResponseEntity<?> responseEntity, RequiredData requiredData) {
        int openBrace = requiredData.getValue().indexOf("{") + 1;
        int closeBrace = requiredData.getValue().indexOf("}");
        String tokenRef = requiredData.getValue().substring(openBrace, closeBrace);
        ArrayList<String> tokenRefParts = new ArrayList<String>(Arrays.asList(tokenRef.split("\\.")));
        boolean isHeader = ((String)tokenRefParts.get(0)).contains("header");
        tokenRefParts.remove(0);
        if (isHeader) {
            HttpHeaders httpHeaders = responseEntity.getHeaders();
            return (String)httpHeaders.get(tokenRefParts.get(0)).get(0);
        }
        if (tokenRef.equals("body")) {
            return responseEntity.getBody().toString().replace("\"", "");
        }
        String path = tokenRefParts.stream().map(Object::toString).collect(Collectors.joining("."));
        String body = responseEntity.getBody().toString();
        return (String)JsonPath.read((String)body, (String)path, (Predicate[])new Predicate[0]);
    }
}

