/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.application.repository;

import com.becon.opencelium.backend.application.entity.SystemOverview;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class SystemOverviewRepository {
    private final DataSource dataSource;
    private final JdbcTemplate jdbcTemplate;
    private final MongoClient mongoClient;
    private final Environment env;

    public SystemOverviewRepository(DataSource dataSource, JdbcTemplate jdbcTemplate, Environment environment, MongoClient mongoClient) {
        this.dataSource = dataSource;
        this.jdbcTemplate = jdbcTemplate;
        this.mongoClient = mongoClient;
        this.env = environment;
    }

    public SystemOverview getCurrentOverview() {
        SystemOverview systemOverview = new SystemOverview();
        systemOverview.setJava(System.getProperty("java.version"));
        systemOverview.setOs(System.getProperty("os.name"));
        try {
            String dbVersion = this.dataSource.getConnection().getMetaData().getDatabaseProductVersion();
            systemOverview.setMariadb(dbVersion);
        }
        catch (SQLException e) {
            e.printStackTrace();
            systemOverview.setMariadb("Service is down. Unable to detect version. ");
        }
        try {
            MongoDatabase database = this.mongoClient.getDatabase("admin");
            Document buildInfo = database.runCommand((Bson)new Document("buildInfo", (Object)1));
            String mongoVersion = buildInfo.getString((Object)"version");
            systemOverview.setMongodb(mongoVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
            systemOverview.setMongodb("Service is down. Unable to detect version. ");
        }
        return systemOverview;
    }

    public String getCurrentVersion() {
        try {
            return Objects.requireNonNull(this.env.getProperty("opencelium.version"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getVersionFromGit() {
        try {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Path path = Paths.get("", new String[0]);
            File workTree = new File(path.toUri()).toPath().getParent().getParent().toFile();
            File gitDir = new File(workTree.getPath() + "/.git");
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(gitDir)).setWorkTree(workTree)).build();
            Git git = new Git(repository);
            String version = git.describe().call();
            if (version == null) {
                throw new RuntimeException("OC_VERSION_NOT_DETERMINED");
            }
            if (version.length() > 7) {
                version = version.charAt(4) == '-' ? version.substring(0, 4) : version.substring(0, 6);
            }
            return version;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getVersionFromStream(InputStream inputStream) {
        try {
            ZipInputStream zis = new ZipInputStream(inputStream);
            ZipEntry zipEntry = zis.getNextEntry();
            byte[] buffer = new byte[1024];
            int read = 0;
            StringBuilder stringBuilder = new StringBuilder();
            while (zipEntry != null) {
                if (zipEntry.getName().contains("backend/src/main/resources/application_default.yml")) {
                    while ((read = zis.read(buffer, 0, 1024)) >= 0) {
                        stringBuilder.append(new String(buffer, 0, read));
                    }
                    String version = SystemOverviewRepository.extractValueFromYaml((String)stringBuilder.toString(), (String)"opencelium.version");
                    if (version == null || version.isEmpty()) {
                        return "VERSION_IN_APPLICATION_DEFAULT_NOT_FOUND";
                    }
                    return version;
                }
                zipEntry = zis.getNextEntry();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "APPLICATION_DEFAULT_NOT_FOUND";
    }

    private static String extractValueFromYaml(String yamlContent, String path) {
        YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
        ByteArrayResource resource = new ByteArrayResource(yamlContent.getBytes());
        yamlFactory.setResources(new Resource[]{resource});
        Properties properties = yamlFactory.getObject();
        if (properties != null) {
            return properties.getProperty(path);
        }
        return null;
    }
}

