/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.application.health;

import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;

@Component(value="mariaDB")
public class MariaDbHealthIndicator
extends AbstractHealthIndicator {
    private final DataSource dataSource;

    public MariaDbHealthIndicator(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try (Connection connection = this.dataSource.getConnection();){
            builder.withDetail("version", (Object)connection.getMetaData().getDatabaseProductVersion());
            builder.up().withDetail("name", (Object)connection.getMetaData().getDatabaseProductName());
        }
        catch (Exception e) {
            builder.down().withDetail("error", (Object)"MariaDB is down");
        }
    }
}

