/*
 * Decompiled with CFR 0.152.
 */
package com.becon.opencelium.backend.api.module;

import com.becon.opencelium.backend.api.exception.RemoteApiException;
import com.becon.opencelium.backend.api.module.SubscriptionModule;
import java.io.File;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class SubscriptionModuleImpl
implements SubscriptionModule {
    private final RestTemplate rt;

    public SubscriptionModuleImpl(RestTemplate rt) {
        this.rt = rt;
    }

    public ResponseEntity<String> getAllSubs() {
        String endpoint = "/api/opencelium/license/all";
        try {
            return this.rt.getForEntity(endpoint, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            throw new RemoteApiException("Service is not reachable at " + endpoint, (Throwable)e);
        }
    }

    public ResponseEntity<String> getSubById(String id) {
        String endpoint = "/api/opencelium/license/" + id;
        try {
            return this.rt.getForEntity(endpoint, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            throw new RemoteApiException("Service is not reachable at " + endpoint, (Throwable)e);
        }
    }

    public ResponseEntity<String> generateLicenseKey(File activeRequest, String subId) {
        String endpoint = "/api/opencelium/license/generate/" + subId;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"file", (Object)new FileSystemResource(activeRequest));
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            return this.rt.exchange(endpoint, HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            throw new RemoteApiException("Service is not reachable at " + endpoint, (Throwable)e);
        }
    }
}

